Notebook[{

Cell[CellGroupData[{
Cell["\<\

      Basic examples with xConf\
\>", "Subtitle",
 FontSize->24,ExpressionUUID->"b73ea991-a1e7-4945-91d0-4054ec287b18"],

Cell["\<\
xConf is a small package which must be loaded on top of xAct (see \
https://www.xact.es ).
It allows to perform Weyl rescaling which corresponds to what is described as \
\[OpenCurlyQuote]conformal transformation\[CloseCurlyQuote] in appendix D od \
Wald\[CloseCurlyQuote]s Book on General Relativity (1984).

In this example notebook we collect example of the paper.\
\>", "Text",ExpressionUUID->"a9ef2e77-0e93-4fa2-8628-4fcd9bdb00bf"],

Cell[CellGroupData[{

Cell["Set - up", \
"Section",ExpressionUUID->"fbee73f7-0c49-47a5-b99e-0261723fb6da"],

Cell[CellGroupData[{

Cell["Loading package", \
"Subsubsection",ExpressionUUID->"a01f0422-816a-4bb3-ba97-902f22456d74"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<xAct`xConf`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",ExpressionUUID->"678b56c2-43ca-42da-a7c6-2d1dc4257ac4"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"a7aa5275-a19a-4880-bc96-35be92e6bb50"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xPerm`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.3\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2015", ",", "8", ",", "23"}], "}"}]}],
  SequenceForm["Package xAct`xPerm`  version ", "1.2.3", ", ", {2015, 8, 23}],
  
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"c47bc091-14ee-4a8c-9f7a-8b62ceddd582"],

Cell[BoxData["\<\"CopyRight (C) 2003-2020, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"6ebe6df4-da77-4744-9fb2-7eaef028cb18"],

Cell[BoxData["\<\"Connecting to external mac executable...\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"1220b62b-6bc6-4eeb-9a1d-131bb32f0340"],

Cell[BoxData["\<\"Connection established.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"fef384d0-c57d-410f-86f8-b63e5b2c37c1"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"34fdea5e-68dd-4fcb-8021-e0ad4e697421"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xTensor`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.0\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2021", ",", "10", ",", "17"}], "}"}]}],
  SequenceForm[
  "Package xAct`xTensor`  version ", "1.2.0", ", ", {2021, 10, 17}],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"884add12-32f9-455a-9f67-caa3dfc6e207"],

Cell[BoxData["\<\"CopyRight (C) 2002-2021, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"2d04286c-a1d6-4bb4-b1a0-d3fc378ae34d"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"f9256715-f6e3-4ce7-a5f6-b12f974a5198"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xConf`  version \"\>", 
   "\[InvisibleSpace]", "\<\"0.0.1\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2025", ",", "4", ",", "4"}], "}"}]}],
  SequenceForm["Package xAct`xConf`  version ", "0.0.1", ", ", {2025, 4, 4}],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"5a7ef3de-97fb-471e-8dea-128ab99065c8"],

Cell[BoxData["\<\"CopyRight (C) 2025-2026, Cyril Pitrou, Guillaume under the \
General Public License.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"cef5860c-99e6-4e3d-921b-756f5669fca3"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"5b02d38d-db76-4094-96a7-ffe34499183e"],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"41895b9c-e1ea-41f0-98bc-fb5ae04d33d6"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"55b31679-80b6-4227-b5c1-5ad6f6992b66"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** Option \"\>", "\[InvisibleSpace]", "AllowUpperDerivatives", 
   "\[InvisibleSpace]", "\<\" of \"\>", "\[InvisibleSpace]", "ContractMetric",
    "\[InvisibleSpace]", "\<\" changed from \"\>", "\[InvisibleSpace]", 
   "False", "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", "True"}],
  SequenceForm[
  "** Option ", xAct`xTensor`AllowUpperDerivatives, " of ", 
   xAct`xTensor`ContractMetric, " changed from ", False, " to ", True],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"e737d69d-e2f8-4b4a-b333-c0a014d8739b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** Option \"\>", "\[InvisibleSpace]", "UseMetricOnVBundle", 
   "\[InvisibleSpace]", "\<\" of \"\>", "\[InvisibleSpace]", "ToCanonical", 
   "\[InvisibleSpace]", "\<\" changed from \"\>", "\[InvisibleSpace]", "All", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", "None"}],
  SequenceForm[
  "** Option ", xAct`xTensor`UseMetricOnVBundle, " of ", 
   xAct`xTensor`ToCanonical, " changed from ", All, " to ", None],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"a805e1a2-3649-4078-8985-0e10c46a69f9"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"$PrePrint", "=", "ScreenDollarIndices"}], ";"}]], "Input",
 CellLabel->
  "In[11]:=",ExpressionUUID->"dbbe2551-684f-44b7-b372-7698048a09aa"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Set - up manifold and conformal relations", \
"Subsubsection",ExpressionUUID->"36a7f468-076b-4507-908d-d3d2fef02bf0"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"DefManifold", "[", 
  RowBox[{"M", ",", "4", ",", 
   RowBox[{"{", 
    RowBox[{
    "\[Alpha]", ",", "\[Beta]", ",", "\[Gamma]", ",", "\[Mu]", ",", "\[Nu]", 
     ",", "\[Lambda]", ",", "\[Sigma]"}], "}"}]}], "]"}], "\n", 
 RowBox[{
  RowBox[{"DefMetric", "[", 
   RowBox[{
    RowBox[{"-", "1"}], ",", 
    RowBox[{"g", "[", 
     RowBox[{
      RowBox[{"-", "\[Alpha]"}], ",", 
      RowBox[{"-", "\[Beta]"}]}], "]"}], ",", "CD", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<;\>\"", ",", "\"\<\[Del]\>\""}], "}"}], ",", 
    RowBox[{"PrintAs", "\[Rule]", "\"\<g\>\""}]}], "]"}], ";"}]}], "Input",
 CellLabel->"In[2]:=",ExpressionUUID->"e5a250ec-cb66-4862-b7ba-440ac45c6456"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefManifold", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"manifold \"\>", "\[InvisibleSpace]", "M", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefManifold, ": Defining ", "manifold ", $CellContext`M,
    ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"73c8a615-f636-4851-8df2-02ae5569b5bd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "TangentM", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`TangentM, ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"4eeb883c-6905-421b-b919-8ea577a749d9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric metric tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric metric tensor ", 
   $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Beta]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"52d6485c-86fd-4d3c-a656-9e3894222589"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric tensor \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"epsilong", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric tensor ", 
   $CellContext`epsilong[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"9fcd934f-b3d3-46b9-bb34-a1860e0a29b8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tetrametric \"\>", "\[InvisibleSpace]", 
   RowBox[{"Tetrag", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tetrametric ", 
   $CellContext`Tetrag[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"c92e8caf-7193-4ff7-b031-9a82f4b82e00"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tetrametric \"\>", "\[InvisibleSpace]", 
   RowBox[{"Tetrag\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tetrametric ", 
   $CellContext`Tetrag\[Dagger][-$CellContext`\[Alpha], \
-$CellContext`\[Beta], -$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ",
    ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"5fa0f0bf-4765-4ebc-9e40-b9ed16e059a9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"CD", "[", 
    RowBox[{"-", "\[Alpha]"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`CD[-$CellContext`\[Alpha]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"05c9c59c-f37a-4c62-b901-5d21716a6333"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing torsion tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TorsionCD", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing torsion tensor ", 
   $CellContext`TorsionCD[$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"8dc6e8ef-d271-47cd-9288-f33e1dab211b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCD", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Christoffel tensor ", 
   $CellContext`ChristoffelCD[$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"f322c346-0fe0-43d7-afb4-e2d5d05e5aa8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannCD", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannCD[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"bb9917c3-2742-4c2f-b6bc-6b7552ee30e6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciCD", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric Ricci tensor ", 
   $CellContext`RicciCD[-$CellContext`\[Alpha], -$CellContext`\[Beta]], ". ", 
   ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"92d3680e-36fd-4058-adc2-710b5aa3bb00"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Riemann automatically replaced \
by Ricci.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"389e033a-0c44-4302-85f1-a47f6deda6a6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"RicciScalarCD", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Ricci scalar ", 
   $CellContext`RicciScalarCD[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"6a04f322-80bf-477d-9255-25e3965f58a7"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Ricci automatically replaced \
by RicciScalar.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"722cae99-0a6c-44ef-bb9e-791d2b3a3418"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Einstein tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"EinsteinCD", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Einstein tensor ", 
   $CellContext`EinsteinCD[-$CellContext`\[Alpha], -$CellContext`\[Beta]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"576d7ba9-6fe8-4536-9f4a-0ea09c075f0d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Weyl tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"WeylCD", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "Weyl tensor ", 
   $CellContext`WeylCD[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"d25ce6cd-9945-4b5b-9ead-25c75c4d2bab"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric TFRicci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TFRicciCD", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric TFRicci tensor ", 
   $CellContext`TFRicciCD[-$CellContext`\[Alpha], -$CellContext`\[Beta]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"be77d0ac-80fa-4af1-8878-dc42ef53b58c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Kretschmann scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"KretschmannCD", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Kretschmann scalar ", 
   $CellContext`KretschmannCD[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"9ec5d4fb-66b2-4b28-9718-0ee3a1f8b820"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RiemannToWeylRules for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RiemannToWeylRules for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"01bd992f-7297-4e0b-b932-5313c8abbde6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToTFRicci for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RicciToTFRicci for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"5af5e717-5362-479a-bef6-558b15b00efa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToEinsteinRules for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RicciToEinsteinRules for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"2e4d0394-631a-4fdb-8c1f-b54fdc925cc9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density \"\>", "\[InvisibleSpace]", 
   RowBox[{"Detg", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Determinant.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "weight +2 density ", 
   $CellContext`Detg[], ". ", "Determinant."],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[2]:=",ExpressionUUID->"5960ff7c-8c72-4ae7-9fc5-9612e203d7a3"]
}, Open  ]]
}, Open  ]],

Cell["\<\
We define several metrics which are conformally related to g.\
\>", "Text",ExpressionUUID->"7233aac8-9b37-4856-be3a-04f44c3e11f3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefConformalMetric", "[", 
  RowBox[{"g", ",", "S1", ",", 
   RowBox[{"FrameColor", "->", "Red"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",ExpressionUUID->"5fd15a73-c93c-4f82-9220-eae3263c5564"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Choosing color \"\>", "\[InvisibleSpace]", 
   TemplateBox[<|"color" -> RGBColor[1, 0, 0]|>,
    "RGBColorSwatchTemplate"], 
   "\[InvisibleSpace]", "\<\" for this conformal frame.\"\>"}],
  SequenceForm["Choosing color ", 
   RGBColor[1, 0, 0], " for this conformal frame."],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"3d05a54f-6756-4c4d-a8f8-110c85af451d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"S1", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`S1[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"22475cf8-3932-4450-a7be-29b16dd34b9f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric metric tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"gS12", "[", 
    RowBox[{
     RowBox[{"-", "\[Sigma]$5511"}], ",", 
     RowBox[{"-", "\[Sigma]$5512"}]}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric metric tensor ", 
   $CellContext`gS12[-$CellContext`\[Sigma]$5511, \
-$CellContext`\[Sigma]$5512], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"97bd81fe-59a8-456e-8c1b-0aa5388230e4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"inverse metric tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"InvgS12", "[", 
    RowBox[{"\[Sigma]$5511", ",", "\[Sigma]$5512"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Metric is frozen!\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "inverse metric tensor ", 
   $CellContext`InvgS12[$CellContext`\[Sigma]$5511, \
$CellContext`\[Sigma]$5512], ". ", "Metric is frozen!"],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"1f5b5378-c922-400d-950c-db865041a876"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric tensor \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"epsilongS12", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric tensor ", 
   $CellContext`epsilongS12[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"9886734c-e36a-400b-8363-8b4d61918087"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tetrametric \"\>", "\[InvisibleSpace]", 
   RowBox[{"TetragS12", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tetrametric ", 
   $CellContext`TetragS12[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"b6ec643e-0dc3-431d-badd-2796fee15b03"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tetrametric \"\>", "\[InvisibleSpace]", 
   RowBox[{"TetragS12\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tetrametric ", 
   $CellContext`TetragS12\[Dagger][-$CellContext`\[Alpha], -$CellContext`\
\[Beta], -$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"2bad7ce8-21cf-4d1b-9682-6c52271fb512"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"CDgS12", "[", 
    RowBox[{"-", "\[Sigma]$5511"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`CDgS12[-$CellContext`\[Sigma]$5511], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"0d4f567c-b48d-482c-ab1b-c7a6b15718e6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing torsion tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TorsionCDgS12", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing torsion tensor ", 
   $CellContext`TorsionCDgS12[$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"306371c5-a871-4719-bc18-2ea4197c4bc7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCDgS12", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Christoffel tensor ", 
   $CellContext`ChristoffelCDgS12[$CellContext`\[Alpha], \
-$CellContext`\[Beta], -$CellContext`\[Gamma]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"ec00777c-3d85-4505-9b58-512faaeeba2e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannDownCDgS12", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannDownCDgS12[-$CellContext`\[Alpha], -$CellContext`\
\[Beta], -$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"1072d0c1-6207-4779-9c11-55b71fc9276e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannCDgS12", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", "\[Lambda]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Antisymmetric only in the first pair.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannCDgS12[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], $CellContext`\[Lambda]], ". ", 
   "Antisymmetric only in the first pair."],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"cc7bb01a-6998-4ec0-a64c-2304d07039d7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciCDgS12", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric Ricci tensor ", 
   $CellContext`RicciCDgS12[-$CellContext`\[Alpha], -$CellContext`\[Beta]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"13d8ec6b-2114-4d9a-a552-0c7446e4b8ec"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Riemann automatically replaced \
by Ricci.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"6a7e4b15-5e0f-4669-b5eb-ed94b2c62830"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"RicciScalarCDgS12", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Ricci scalar ", 
   $CellContext`RicciScalarCDgS12[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"6be457d0-53a5-42b5-9b41-fec24b29203c"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Ricci automatically replaced \
by RicciScalar.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"4960d8df-5cda-43ed-9081-088dde8ca17b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Einstein tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"EinsteinCDgS12", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Einstein tensor ", 
   $CellContext`EinsteinCDgS12[-$CellContext`\[Alpha], -$CellContext`\[Beta]],
    ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"b92c2825-d68e-4ec4-80cd-e305c171bde0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Weyl tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"WeylCDgS12", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "Weyl tensor ", 
   $CellContext`WeylCDgS12[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"8dcf149a-fd19-4b04-995d-b2427e19a23e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric TFRicci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TFRicciCDgS12", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric TFRicci tensor ", 
   $CellContext`TFRicciCDgS12[-$CellContext`\[Alpha], -$CellContext`\[Beta]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"3d30d0a6-129e-462a-971a-e57cb1e0f10e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Kretschmann scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"KretschmannCDgS12", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Kretschmann scalar ", 
   $CellContext`KretschmannCDgS12[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"29d0b3e9-ff8a-4a06-9c34-b1de9f5a5dcf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RiemannToWeylRules for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RiemannToWeylRules for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"33280b2f-2d5e-4095-9adb-11ca9db673a2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToEinsteinRules for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RicciToEinsteinRules for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"a8ddb53b-476c-490c-996e-a00e20501a2e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density \"\>", "\[InvisibleSpace]", 
   RowBox[{"DetgS12", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Determinant.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "weight +2 density ", 
   $CellContext`DetgS12[], ". ", "Determinant."],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"f532f3f1-32a4-4cbc-b3ee-fda4955de6d2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefInertHead", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"inert head \"\>", "\[InvisibleSpace]", 
   RowBox[{"ConformalFrame", "[", "gS12", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefInertHead, ": Defining ", "inert head ", 
   xAct`xConf`ConformalFrame[$CellContext`gS12], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"6479cebe-38b9-4238-873f-19ad502ae993"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefInertHead", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"inert head \"\>", "\[InvisibleSpace]", 
   RowBox[{"ConformalFrame", "[", "g", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefInertHead, ": Defining ", "inert head ", 
   xAct`xConf`ConformalFrame[$CellContext`g], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"ac42dec0-b20e-42f7-96ec-077577987f24"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefConformalMetric", "[", 
  RowBox[{"gS12", ",", "S2", ",", 
   RowBox[{"FrameColor", "->", "Blue"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",ExpressionUUID->"40838c7e-deae-46da-abd2-5456ea947e83"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Choosing color \"\>", "\[InvisibleSpace]", 
   TemplateBox[<|"color" -> RGBColor[0, 0, 1]|>,
    "RGBColorSwatchTemplate"], 
   "\[InvisibleSpace]", "\<\" for this conformal frame.\"\>"}],
  SequenceForm["Choosing color ", 
   RGBColor[0, 0, 1], " for this conformal frame."],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"69e2ff20-e2af-4b64-9155-680e66099379"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"S2", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`S2[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"c32338df-db33-45d5-9d34-db538f908723"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric metric tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"gS12S22", "[", 
    RowBox[{
     RowBox[{"-", "\[Sigma]$7888"}], ",", 
     RowBox[{"-", "\[Sigma]$7889"}]}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric metric tensor ", 
   $CellContext`gS12S22[-$CellContext`\[Sigma]$7888, \
-$CellContext`\[Sigma]$7889], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"4fbab18a-a74e-45ba-945f-75440d39f3d1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"inverse metric tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"InvgS12S22", "[", 
    RowBox[{"\[Sigma]$7888", ",", "\[Sigma]$7889"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Metric is frozen!\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "inverse metric tensor ", 
   $CellContext`InvgS12S22[$CellContext`\[Sigma]$7888, \
$CellContext`\[Sigma]$7889], ". ", "Metric is frozen!"],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"c1838bff-50d7-4c92-a399-5f09a2e9164a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric tensor \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"epsilongS12S22", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric tensor ", 
   $CellContext`epsilongS12S22[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"80554645-4904-419b-9532-f23eac6168a3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tetrametric \"\>", "\[InvisibleSpace]", 
   RowBox[{"TetragS12S22", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tetrametric ", 
   $CellContext`TetragS12S22[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"d1467ca8-873f-49ce-8a29-f7aa9b805d0c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tetrametric \"\>", "\[InvisibleSpace]", 
   RowBox[{"TetragS12S22\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tetrametric ", 
   $CellContext`TetragS12S22\[Dagger][-$CellContext`\[Alpha], -$CellContext`\
\[Beta], -$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"58047bc1-7353-4f6a-bad3-bdd4ed906e92"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"CDgS12gS12S22", "[", 
    RowBox[{"-", "\[Sigma]$7888"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`CDgS12gS12S22[-$CellContext`\[Sigma]$7888], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"ab0b6113-807c-40fd-b4d5-dc0ade44ab79"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing torsion tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TorsionCDgS12gS12S22", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing torsion tensor ", 
   $CellContext`TorsionCDgS12gS12S22[$CellContext`\[Alpha], -$CellContext`\
\[Beta], -$CellContext`\[Gamma]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"e3636ac1-91c8-4449-889d-8d5c02583f99"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCDgS12gS12S22", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Christoffel tensor ", 
   $CellContext`ChristoffelCDgS12gS12S22[$CellContext`\[Alpha], \
-$CellContext`\[Beta], -$CellContext`\[Gamma]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"73cffe32-30ea-48ad-8ce5-36aa28972c06"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannDownCDgS12gS12S22", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannDownCDgS12gS12S22[-$CellContext`\[Alpha], \
-$CellContext`\[Beta], -$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ",
    ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"2bb3b11e-5bca-4f07-a5c7-2dda799b8adc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannCDgS12gS12S22", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", "\[Lambda]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Antisymmetric only in the first pair.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannCDgS12gS12S22[-$CellContext`\[Alpha], -$CellContext`\
\[Beta], -$CellContext`\[Gamma], $CellContext`\[Lambda]], ". ", 
   "Antisymmetric only in the first pair."],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"b4e4311f-9054-4989-828c-db833cd6d964"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciCDgS12gS12S22", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric Ricci tensor ", 
   $CellContext`RicciCDgS12gS12S22[-$CellContext`\[Alpha], -$CellContext`\
\[Beta]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"814894e5-39d1-45ef-a3f8-d9cb0516810e"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Riemann automatically replaced \
by Ricci.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"b49ca41a-d828-4e69-93eb-f81b66434395"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"RicciScalarCDgS12gS12S22", "[", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Ricci scalar ", 
   $CellContext`RicciScalarCDgS12gS12S22[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"9ffb36eb-eb16-47fb-9e9b-91a90c397516"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Ricci automatically replaced \
by RicciScalar.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"96fc81f9-5bd0-4402-ba5b-f33abac76a2b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Einstein tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"EinsteinCDgS12gS12S22", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Einstein tensor ", 
   $CellContext`EinsteinCDgS12gS12S22[-$CellContext`\[Alpha], -$CellContext`\
\[Beta]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"67e8ba7d-02b3-4716-a6fc-4b7165b5fe91"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Weyl tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"WeylCDgS12gS12S22", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Gamma]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "Weyl tensor ", 
   $CellContext`WeylCDgS12gS12S22[-$CellContext`\[Alpha], -$CellContext`\
\[Beta], -$CellContext`\[Gamma], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"df8d8b6b-a70a-480d-909a-f4b21c8d1a24"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric TFRicci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TFRicciCDgS12gS12S22", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric TFRicci tensor ", 
   $CellContext`TFRicciCDgS12gS12S22[-$CellContext`\[Alpha], -$CellContext`\
\[Beta]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"addc402c-12e9-4f20-afe9-aa6da3ccca1a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Kretschmann scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"KretschmannCDgS12gS12S22", "[", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Kretschmann scalar ", 
   $CellContext`KretschmannCDgS12gS12S22[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"98615c71-a3e6-4903-8d52-7baa8599e841"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RiemannToWeylRules for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RiemannToWeylRules for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"81b038d1-6ff0-4917-9858-bda5363dfd21"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToEinsteinRules for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RicciToEinsteinRules for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"12c5423d-cd8c-43ef-8820-1a5c687e7027"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density \"\>", "\[InvisibleSpace]", 
   RowBox[{"DetgS12S22", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Determinant.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "weight +2 density ", 
   $CellContext`DetgS12S22[], ". ", "Determinant."],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"666e4927-c01e-411e-8982-4eea3f2f1447"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefInertHead", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"inert head \"\>", "\[InvisibleSpace]", 
   RowBox[{"ConformalFrame", "[", "gS12S22", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefInertHead, ": Defining ", "inert head ", 
   xAct`xConf`ConformalFrame[$CellContext`gS12S22], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[5]:=",ExpressionUUID->"72fa6c02-15d1-486a-88ba-ce6c33652d48"]
}, Open  ]]
}, Open  ]],

Cell["\<\
We check that we now have 3 metrics, but only the first one is used to raise \
and lower indices . This is the ambient metric .\
\>", "Text",ExpressionUUID->"47f3d780-3e97-4608-9511-f3c4a8473788"],

Cell[CellGroupData[{

Cell[BoxData["$Metrics"], "Input",
 CellLabel->"In[6]:=",ExpressionUUID->"035a2530-fef1-40c7-93eb-141dc6dbe2ea"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"g", ",", "gS12", ",", "gS12S22"}], "}"}]], "Output",
 CellLabel->"Out[6]=",ExpressionUUID->"081d9677-270c-42d9-9032-057e987dba8d"]
}, Open  ]],

Cell["\<\
The package has defined automatically all relevant conformal rules to relate \
two by two all metrics given the known conformal factors.\
\>", "Text",ExpressionUUID->"cd631931-80b9-456b-b8ad-19127b7f93df"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ConformalRules", "[", 
  RowBox[{"g", ",", "gS12"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ConformalRules", "[", 
  RowBox[{"g", ",", "gS12S22"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ConformalRules", "[", 
  RowBox[{"gS12", ",", "gS12S22"}], "]"}]}], "Input",
 CellLabel->"In[12]:=",ExpressionUUID->"ceb81265-5e81-4ee7-94b1-7498416bbcd8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {
             UnderscriptBox[
              UnderscriptBox["\[Alpha]", "_"], "_"], 
             UnderscriptBox[
              UnderscriptBox["\[Beta]", "_"], "_"]},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[
      PatternTest[
       Pattern[$CellContext`\[Alpha], 
        Blank[]], xAct`xTensor`DownIndexQ], 
      PatternTest[
       Pattern[$CellContext`\[Beta], 
        Blank[]], xAct`xTensor`DownIndexQ]],
     Editable->False], "\[Rule]", 
    FractionBox[
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"[", 
           RowBox[{"g", 
            SuperscriptBox["S1", "2"]}], "]"}], 
          StyleBox[GridBox[{
             {"\[Alpha]", "\[Beta]"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`gS12[$CellContext`\[Alpha], $CellContext`\[Beta]],
      Editable->False], 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["S1",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`S1[],
       Editable->False], "2"]]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {
             UnderscriptBox[
              UnderscriptBox["\[Alpha]", "_"], "_"], 
             UnderscriptBox[
              UnderscriptBox["\[Beta]", "_"], "_"]},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[
      PatternTest[
       Pattern[$CellContext`\[Alpha], 
        Blank[]], xAct`xTensor`UpIndexQ], 
      PatternTest[
       Pattern[$CellContext`\[Beta], 
        Blank[]], xAct`xTensor`UpIndexQ]],
     Editable->False], "\[Rule]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"i", "[", 
           RowBox[{"g", 
            SuperscriptBox["S1", "2"]}], "]"}], 
          StyleBox[GridBox[{
             {"\[Alpha]", "\[Beta]"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`InvgS12[$CellContext`\[Alpha], $CellContext`\[Beta]],
      Editable->False], " ", 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["S1",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`S1[],
       Editable->False], "2"]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      OverscriptBox["g", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Detg[],
     Editable->False], "\[Rule]", 
    FractionBox[
     InterpretationBox[
      StyleBox[
       OverscriptBox[
        RowBox[{"[", 
         RowBox[{"g", 
          SuperscriptBox["S1", "2"]}], "]"}], 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`DetgS12[],
      Editable->False], 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["S1",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`S1[],
       Editable->False], "8"]]}]}], "}"}]], "Output",
 CellLabel->"Out[12]=",ExpressionUUID->"1d77d1ac-0997-461a-8436-244abfa32c62"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {
             UnderscriptBox[
              UnderscriptBox["\[Alpha]", "_"], "_"], 
             UnderscriptBox[
              UnderscriptBox["\[Beta]", "_"], "_"]},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[
      PatternTest[
       Pattern[$CellContext`\[Alpha], 
        Blank[]], xAct`xTensor`DownIndexQ], 
      PatternTest[
       Pattern[$CellContext`\[Beta], 
        Blank[]], xAct`xTensor`DownIndexQ]],
     Editable->False], "\[Rule]", 
    FractionBox[
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"[", 
           RowBox[{
            RowBox[{"[", 
             RowBox[{"g", 
              SuperscriptBox["S1", "2"]}], "]"}], 
            SuperscriptBox["S2", "2"]}], "]"}], 
          StyleBox[GridBox[{
             {"\[Alpha]", "\[Beta]"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`gS12S22[$CellContext`\[Alpha], $CellContext`\[Beta]],
      Editable->False], 
     RowBox[{
      SuperscriptBox[
       InterpretationBox[
        StyleBox["S1",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`S1[],
        Editable->False], "2"], " ", 
      SuperscriptBox[
       InterpretationBox[
        StyleBox["S2",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`S2[],
        Editable->False], "2"]}]]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {
             UnderscriptBox[
              UnderscriptBox["\[Alpha]", "_"], "_"], 
             UnderscriptBox[
              UnderscriptBox["\[Beta]", "_"], "_"]},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[
      PatternTest[
       Pattern[$CellContext`\[Alpha], 
        Blank[]], xAct`xTensor`UpIndexQ], 
      PatternTest[
       Pattern[$CellContext`\[Beta], 
        Blank[]], xAct`xTensor`UpIndexQ]],
     Editable->False], "\[Rule]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"i", "[", 
           RowBox[{
            RowBox[{"[", 
             RowBox[{"g", 
              SuperscriptBox["S1", "2"]}], "]"}], 
            SuperscriptBox["S2", "2"]}], "]"}], 
          StyleBox[GridBox[{
             {"\[Alpha]", "\[Beta]"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`InvgS12S22[$CellContext`\[Alpha], $CellContext`\[Beta]],
      Editable->False], " ", 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["S1",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`S1[],
       Editable->False], "2"], " ", 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["S2",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`S2[],
       Editable->False], "2"]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      OverscriptBox["g", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Detg[],
     Editable->False], "\[Rule]", 
    FractionBox[
     InterpretationBox[
      StyleBox[
       OverscriptBox[
        RowBox[{"[", 
         RowBox[{
          RowBox[{"[", 
           RowBox[{"g", 
            SuperscriptBox["S1", "2"]}], "]"}], 
          SuperscriptBox["S2", "2"]}], "]"}], 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`DetgS12S22[],
      Editable->False], 
     RowBox[{
      SuperscriptBox[
       InterpretationBox[
        StyleBox["S1",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`S1[],
        Editable->False], "8"], " ", 
      SuperscriptBox[
       InterpretationBox[
        StyleBox["S2",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`S2[],
        Editable->False], "8"]}]]}]}], "}"}]], "Output",
 CellLabel->"Out[13]=",ExpressionUUID->"fba13bba-5848-43e3-bf64-8ea3c2e4edbe"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"[", 
          RowBox[{"g", 
           SuperscriptBox["S1", "2"]}], "]"}], 
         StyleBox[GridBox[{
            {
             UnderscriptBox["\[Alpha]", "_"], 
             UnderscriptBox["\[Beta]", "_"]},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`gS12[
      Pattern[$CellContext`\[Alpha], 
       Blank[]], 
      Pattern[$CellContext`\[Beta], 
       Blank[]]],
     Editable->False], "\[Rule]", 
    FractionBox[
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"[", 
           RowBox[{
            RowBox[{"[", 
             RowBox[{"g", 
              SuperscriptBox["S1", "2"]}], "]"}], 
            SuperscriptBox["S2", "2"]}], "]"}], 
          StyleBox[GridBox[{
             {"\[Alpha]", "\[Beta]"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`gS12S22[$CellContext`\[Alpha], $CellContext`\[Beta]],
      Editable->False], 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["S2",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`S2[],
       Editable->False], "2"]]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {
         RowBox[{"i", "[", 
          RowBox[{"g", 
           SuperscriptBox["S1", "2"]}], "]"}], 
         StyleBox[GridBox[{
            {
             UnderscriptBox["\[Alpha]", "_"], 
             UnderscriptBox["\[Beta]", "_"]},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`InvgS12[
      Pattern[$CellContext`\[Alpha], 
       Blank[]], 
      Pattern[$CellContext`\[Beta], 
       Blank[]]],
     Editable->False], "\[Rule]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"i", "[", 
           RowBox[{
            RowBox[{"[", 
             RowBox[{"g", 
              SuperscriptBox["S1", "2"]}], "]"}], 
            SuperscriptBox["S2", "2"]}], "]"}], 
          StyleBox[GridBox[{
             {"\[Alpha]", "\[Beta]"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`InvgS12S22[$CellContext`\[Alpha], $CellContext`\[Beta]],
      Editable->False], " ", 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["S2",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`S2[],
       Editable->False], "2"]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      OverscriptBox[
       RowBox[{"[", 
        RowBox[{"g", 
         SuperscriptBox["S1", "2"]}], "]"}], 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`DetgS12[],
     Editable->False], "\[Rule]", 
    FractionBox[
     InterpretationBox[
      StyleBox[
       OverscriptBox[
        RowBox[{"[", 
         RowBox[{
          RowBox[{"[", 
           RowBox[{"g", 
            SuperscriptBox["S1", "2"]}], "]"}], 
          SuperscriptBox["S2", "2"]}], "]"}], 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`DetgS12S22[],
      Editable->False], 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["S2",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`S2[],
       Editable->False], "8"]]}]}], "}"}]], "Output",
 CellLabel->
  "Out[14]=",ExpressionUUID->"544424e2-2cbb-4d07-9206-c7ada243d6fd"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tests", \
"Section",ExpressionUUID->"963cb2e8-b388-4db1-82fb-18071965e144"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"U", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Mu]"}], ",", "\[Nu]"}], "]"}], ",", "M"}], 
  "]"}]], "Input",
 CellLabel->"In[30]:=",ExpressionUUID->"48c3820c-026e-4178-b446-11e58d926223"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"U", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Mu]"}], ",", "\[Nu]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`U[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Mu], $CellContext`\[Nu]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[30]:=",ExpressionUUID->"25fa1d56-2226-49b1-80c2-3137d463948f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TS1R", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"ConformalTransformation", "[", 
     RowBox[{"g", ",", "gS12", ",", 
      RowBox[{"FinalFrame", "->", "g"}]}], "]"}], "[", 
    RowBox[{"RiemannCD", "[", 
     RowBox[{
      RowBox[{"-", "\[Alpha]"}], ",", 
      RowBox[{"-", "\[Beta]"}], ",", 
      RowBox[{"-", "\[Mu]"}], ",", "\[Nu]"}], "]"}], "]"}], "-", 
   RowBox[{"RiemannCD", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Mu]"}], ",", "\[Nu]"}], "]"}]}]}]], "Input",
 CellLabel->"In[19]:=",ExpressionUUID->"d68b5a95-f9fa-4a4e-9dc6-cbe5f15ae5d7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "\[Nu]"},
             {"\[Beta]", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {" ", " "},
             {"\[Alpha]", "\[Mu]"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"g", 
              StyleBox[GridBox[{
                 {"\[Alpha]", "\[Beta]"},
                 {" ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->Rational[39, 4]]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`\[Alpha]][
           $CellContext`S1[]],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`\[Beta]][
           $CellContext`S1[]],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
         $CellContext`S1[]] $CellContext`CD[-$CellContext`\[Beta]][
         $CellContext`S1[]]],
      Editable->False]}], 
    SuperscriptBox[
     InterpretationBox[
      StyleBox["S1",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`S1[],
      Editable->False], "2"]]}], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Alpha]][
          $CellContext`S1[]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Beta]][
          $CellContext`S1[]],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
        $CellContext`S1[]] $CellContext`CD[-$CellContext`\[Beta]][
        $CellContext`S1[]]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`S1[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`S1[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], 
       SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`CD[-$CellContext`\[Alpha]][
       $CellContext`S1[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S1",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S1[],
    Editable->False]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], 
       SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`CD[-$CellContext`\[Beta]][
       $CellContext`S1[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S1",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S1[],
    Editable->False]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S1[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S1[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], 
       SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`CD[-$CellContext`\[Alpha]][
       $CellContext`S1[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S1",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S1[],
    Editable->False]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], 
       SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`CD[-$CellContext`\[Beta]][
       $CellContext`S1[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S1",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S1[],
    Editable->False]]}]], "Output",
 CellLabel->
  "Out[19]=",ExpressionUUID->"fb62bdec-9a0a-4b36-b802-d8b3e17297a1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IndexSet", "[", 
  RowBox[{
   RowBox[{"U", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]_"}], ",", 
     RowBox[{"-", "\[Beta]_"}], ",", 
     RowBox[{"-", "\[Mu]_"}], ",", "\[Nu]_"}], "]"}], ",", "TS1R"}], 
  "]"}]], "Input",
 CellLabel->"In[31]:=",ExpressionUUID->"bec5f4b7-8615-4c63-8137-5284d9d63c30"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "\[Nu]"},
             {"\[Beta]", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {" ", " "},
             {"\[Alpha]", "\[Mu]"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"g", 
              StyleBox[GridBox[{
                 {"\[Alpha]", "\[Beta]"},
                 {" ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->Rational[39, 4]]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`\[Alpha]][
           $CellContext`S1[]],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`\[Beta]][
           $CellContext`S1[]],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
         $CellContext`S1[]] $CellContext`CD[-$CellContext`\[Beta]][
         $CellContext`S1[]]],
      Editable->False]}], 
    SuperscriptBox[
     InterpretationBox[
      StyleBox["S1",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`S1[],
      Editable->False], "2"]]}], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Alpha]][
          $CellContext`S1[]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Beta]][
          $CellContext`S1[]],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
        $CellContext`S1[]] $CellContext`CD[-$CellContext`\[Beta]][
        $CellContext`S1[]]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`S1[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`S1[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], 
       SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`CD[-$CellContext`\[Alpha]][
       $CellContext`S1[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S1",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S1[],
    Editable->False]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], 
       SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`CD[-$CellContext`\[Beta]][
       $CellContext`S1[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S1",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S1[],
    Editable->False]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S1[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S1[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], 
       SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`CD[-$CellContext`\[Alpha]][
       $CellContext`S1[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S1",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S1[],
    Editable->False]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], 
       SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`CD[-$CellContext`\[Beta]][
       $CellContext`S1[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S1",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S1[],
    Editable->False]]}]], "Output",
 CellLabel->
  "Out[31]=",ExpressionUUID->"9cc1120b-feda-4854-9f43-e1cd8eab94e8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"U", "[", 
  RowBox[{
   RowBox[{"-", "\[Alpha]"}], ",", 
   RowBox[{"-", "\[Beta]"}], ",", 
   RowBox[{"-", "\[Mu]"}], ",", "\[Nu]"}], "]"}]], "Input",
 CellLabel->"In[33]:=",ExpressionUUID->"23f7edeb-fef9-4d63-9016-fda9e5c9583d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "\[Nu]"},
             {"\[Beta]", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {" ", " "},
             {"\[Alpha]", "\[Mu]"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"g", 
              StyleBox[GridBox[{
                 {"\[Alpha]", "\[Beta]"},
                 {" ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->Rational[39, 4]]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`\[Alpha]][
           $CellContext`S1[]],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`\[Beta]][
           $CellContext`S1[]],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
         $CellContext`S1[]] $CellContext`CD[-$CellContext`\[Beta]][
         $CellContext`S1[]]],
      Editable->False]}], 
    SuperscriptBox[
     InterpretationBox[
      StyleBox["S1",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`S1[],
      Editable->False], "2"]]}], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Alpha]][
          $CellContext`S1[]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Beta]][
          $CellContext`S1[]],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
        $CellContext`S1[]] $CellContext`CD[-$CellContext`\[Beta]][
        $CellContext`S1[]]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`S1[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`S1[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], 
       SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`CD[-$CellContext`\[Alpha]][
       $CellContext`S1[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S1",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S1[],
    Editable->False]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], 
       SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`CD[-$CellContext`\[Beta]][
       $CellContext`S1[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S1",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S1[],
    Editable->False]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S1[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S1[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], 
       SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`CD[-$CellContext`\[Alpha]][
       $CellContext`S1[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S1",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S1[],
    Editable->False]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], 
       SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`CD[-$CellContext`\[Beta]][
       $CellContext`S1[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S1",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S1[],
    Editable->False]]}]], "Output",
 CellLabel->
  "Out[33]=",ExpressionUUID->"91a76dcd-e8ff-4b40-bb1b-1fcc6997fdcc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TS2R", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"ConformalTransformation", "[", 
     RowBox[{"gS12", ",", "gS12S22", ",", 
      RowBox[{"FinalFrame", "->", "g"}]}], "]"}], "[", 
    RowBox[{"RiemannCD", "[", 
     RowBox[{
      RowBox[{"-", "\[Alpha]"}], ",", 
      RowBox[{"-", "\[Beta]"}], ",", 
      RowBox[{"-", "\[Mu]"}], ",", "\[Nu]"}], "]"}], "]"}], "-", 
   RowBox[{"RiemannCD", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Mu]"}], ",", "\[Nu]"}], "]"}]}]}]], "Input",
 CellLabel->"In[20]:=",ExpressionUUID->"a055878b-2dc9-4f39-bff2-79530620db82"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "\[Nu]"},
             {"\[Beta]", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {" ", " "},
             {"\[Alpha]", "\[Mu]"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"g", 
              StyleBox[GridBox[{
                 {"\[Alpha]", "\[Beta]"},
                 {" ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->Rational[39, 4]]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox["\[Del]", "\[Alpha]"], "S2"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`\[Alpha]][
           $CellContext`S2[]],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox["\[Del]", "\[Beta]"], "S2"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`\[Beta]][
           $CellContext`S2[]],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
         $CellContext`S2[]] $CellContext`CD[-$CellContext`\[Beta]][
         $CellContext`S2[]]],
      Editable->False]}], 
    SuperscriptBox[
     InterpretationBox[
      StyleBox["S2",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`S2[],
      Editable->False], "2"]]}], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Alpha]"], "S2"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Alpha]][
          $CellContext`S2[]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Beta]"], "S2"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Beta]][
          $CellContext`S2[]],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
        $CellContext`S2[]] $CellContext`CD[-$CellContext`\[Beta]][
        $CellContext`S2[]]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S2[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`S2[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S2[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`S2[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], 
       SubscriptBox["\[Del]", "\[Alpha]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`CD[-$CellContext`\[Alpha]][
       $CellContext`S2[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S2",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S2[],
    Editable->False]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], 
       SubscriptBox["\[Del]", "\[Beta]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`CD[-$CellContext`\[Beta]][
       $CellContext`S2[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S2",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S2[],
    Editable->False]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S2[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S2[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S2[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S2[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], 
       SubscriptBox["\[Del]", "\[Alpha]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`CD[-$CellContext`\[Alpha]][
       $CellContext`S2[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S2",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S2[],
    Editable->False]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], 
       SubscriptBox["\[Del]", "\[Beta]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`CD[-$CellContext`\[Beta]][
       $CellContext`S2[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S2",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S2[],
    Editable->False]]}]], "Output",
 CellLabel->
  "Out[20]=",ExpressionUUID->"aba8fb3a-7aa0-420e-9fb3-0e8e94066bb9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TS1S2R", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"ConformalTransformation", "[", 
     RowBox[{"g", ",", "gS12S22", ",", 
      RowBox[{"FinalFrame", "->", "g"}]}], "]"}], "[", 
    RowBox[{"RiemannCD", "[", 
     RowBox[{
      RowBox[{"-", "\[Alpha]"}], ",", 
      RowBox[{"-", "\[Beta]"}], ",", 
      RowBox[{"-", "\[Mu]"}], ",", "\[Nu]"}], "]"}], "]"}], "-", 
   RowBox[{"RiemannCD", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Mu]"}], ",", "\[Nu]"}], "]"}]}]}]], "Input",
 CellLabel->"In[21]:=",ExpressionUUID->"ff1910a9-0016-4176-8581-8f7893986804"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "\[Nu]"},
             {"\[Beta]", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {" ", " "},
             {"\[Alpha]", "\[Mu]"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"g", 
              StyleBox[GridBox[{
                 {"\[Alpha]", "\[Beta]"},
                 {" ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->Rational[39, 4]]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`\[Alpha]][
           $CellContext`S1[]],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`\[Beta]][
           $CellContext`S1[]],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
         $CellContext`S1[]] $CellContext`CD[-$CellContext`\[Beta]][
         $CellContext`S1[]]],
      Editable->False]}], 
    SuperscriptBox[
     InterpretationBox[
      StyleBox["S1",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`S1[],
      Editable->False], "2"]]}], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Alpha]][
          $CellContext`S1[]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Beta]][
          $CellContext`S1[]],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
        $CellContext`S1[]] $CellContext`CD[-$CellContext`\[Beta]][
        $CellContext`S1[]]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Alpha]][
          $CellContext`S1[]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Beta]"], "S2"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Beta]][
          $CellContext`S2[]],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
        $CellContext`S1[]] $CellContext`CD[-$CellContext`\[Beta]][
        $CellContext`S2[]]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Alpha]][
          $CellContext`S1[]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Beta]"], "S2"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Beta]][
          $CellContext`S2[]],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
        $CellContext`S1[]] $CellContext`CD[-$CellContext`\[Beta]][
        $CellContext`S2[]]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Alpha]"], "S2"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Alpha]][
          $CellContext`S2[]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Beta]"], "S2"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Beta]][
          $CellContext`S2[]],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
        $CellContext`S2[]] $CellContext`CD[-$CellContext`\[Beta]][
        $CellContext`S2[]]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Alpha]"], "S2"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Alpha]][
          $CellContext`S2[]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Beta]"], "S2"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Beta]][
          $CellContext`S2[]],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
        $CellContext`S2[]] $CellContext`CD[-$CellContext`\[Beta]][
        $CellContext`S2[]]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`S1[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S2[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`S1[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`S1[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S2[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`S1[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`S2[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S2[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`S2[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`S2[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S2[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`S2[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], 
       SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`CD[-$CellContext`\[Alpha]][
       $CellContext`S1[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S1",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S1[],
    Editable->False]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], 
       SubscriptBox["\[Del]", "\[Alpha]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`CD[-$CellContext`\[Alpha]][
       $CellContext`S2[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S2",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S2[],
    Editable->False]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], 
       SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`CD[-$CellContext`\[Beta]][
       $CellContext`S1[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S1",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S1[],
    Editable->False]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], 
       SubscriptBox["\[Del]", "\[Beta]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`CD[-$CellContext`\[Beta]][
       $CellContext`S2[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S2",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S2[],
    Editable->False]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S1[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S2[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S1[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S1[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S2[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S1[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S2[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S2[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S2[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S2[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S2[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S2[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], 
       SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`CD[-$CellContext`\[Alpha]][
       $CellContext`S1[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S1",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S1[],
    Editable->False]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], 
       SubscriptBox["\[Del]", "\[Alpha]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`CD[-$CellContext`\[Alpha]][
       $CellContext`S2[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S2",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S2[],
    Editable->False]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], 
       SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`CD[-$CellContext`\[Beta]][
       $CellContext`S1[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S1",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S1[],
    Editable->False]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], 
       SubscriptBox["\[Del]", "\[Beta]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`CD[-$CellContext`\[Beta]][
       $CellContext`S2[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S2",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S2[],
    Editable->False]]}]], "Output",
 CellLabel->
  "Out[21]=",ExpressionUUID->"5d9834c9-2081-406d-b833-2269833fc558"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TS2TS1R", "=", 
  RowBox[{
   RowBox[{"ConformalTransformation", "[", 
    RowBox[{"gS12", ",", "gS12S22", ",", 
     RowBox[{"FinalFrame", "->", "g"}]}], "]"}], "[", "TS1R", 
   "]"}]}]], "Input",
 CellLabel->"In[22]:=",ExpressionUUID->"804d510c-18f1-462c-a697-a141886e8768"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "\[Nu]"},
             {"\[Beta]", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {" ", " "},
             {"\[Alpha]", "\[Mu]"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"g", 
              StyleBox[GridBox[{
                 {"\[Alpha]", "\[Beta]"},
                 {" ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->Rational[39, 4]]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`\[Alpha]][
           $CellContext`S1[]],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`\[Beta]][
           $CellContext`S1[]],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
         $CellContext`S1[]] $CellContext`CD[-$CellContext`\[Beta]][
         $CellContext`S1[]]],
      Editable->False]}], 
    SuperscriptBox[
     InterpretationBox[
      StyleBox["S1",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`S1[],
      Editable->False], "2"]]}], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Alpha]][
          $CellContext`S1[]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Beta]][
          $CellContext`S1[]],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
        $CellContext`S1[]] $CellContext`CD[-$CellContext`\[Beta]][
        $CellContext`S1[]]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Alpha]][
          $CellContext`S1[]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Beta]"], "S2"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Beta]][
          $CellContext`S2[]],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
        $CellContext`S1[]] $CellContext`CD[-$CellContext`\[Beta]][
        $CellContext`S2[]]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Alpha]][
          $CellContext`S1[]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Beta]"], "S2"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Beta]][
          $CellContext`S2[]],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
        $CellContext`S1[]] $CellContext`CD[-$CellContext`\[Beta]][
        $CellContext`S2[]]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`S1[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S2[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`S1[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`S1[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S2[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`S1[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`S2[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`S2[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], 
       SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`CD[-$CellContext`\[Alpha]][
       $CellContext`S1[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S1",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S1[],
    Editable->False]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Nu]", "\[Gamma]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Nu], $CellContext`\[Gamma]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Gamma]"], 
       SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Gamma]][
      $CellContext`CD[-$CellContext`\[Beta]][
       $CellContext`S1[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S1",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S1[],
    Editable->False]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S1[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S2[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S1[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S1[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S2[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S1[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S2[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S2[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], 
       SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`CD[-$CellContext`\[Alpha]][
       $CellContext`S1[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S1",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S1[],
    Editable->False]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], 
       SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`CD[-$CellContext`\[Beta]][
       $CellContext`S1[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S1",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S1[],
    Editable->False]]}]], "Output",
 CellLabel->
  "Out[22]=",ExpressionUUID->"40a60f7f-a1d7-443e-ad7a-3448056319ee"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ContractMetric", "[", 
   RowBox[{"TS2TS1R", "+", "TS2R"}], "]"}], "//", "ToCanonical"}]], "Input",
 CellLabel->"In[23]:=",ExpressionUUID->"49ee204d-243a-4a30-9f4a-a410b20dd028"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "\[Nu]"},
             {"\[Beta]", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {" ", " "},
             {"\[Alpha]", "\[Mu]"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"g", 
              StyleBox[GridBox[{
                 {"\[Alpha]", "\[Beta]"},
                 {" ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->Rational[39, 4]]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`\[Alpha]][
           $CellContext`S1[]],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`\[Beta]][
           $CellContext`S1[]],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
         $CellContext`S1[]] $CellContext`CD[-$CellContext`\[Beta]][
         $CellContext`S1[]]],
      Editable->False]}], 
    SuperscriptBox[
     InterpretationBox[
      StyleBox["S1",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`S1[],
      Editable->False], "2"]]}], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Alpha]][
          $CellContext`S1[]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Beta]][
          $CellContext`S1[]],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
        $CellContext`S1[]] $CellContext`CD[-$CellContext`\[Beta]][
        $CellContext`S1[]]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Alpha]][
          $CellContext`S1[]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Beta]"], "S2"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Beta]][
          $CellContext`S2[]],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
        $CellContext`S1[]] $CellContext`CD[-$CellContext`\[Beta]][
        $CellContext`S2[]]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Alpha]][
          $CellContext`S1[]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Beta]"], "S2"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Beta]][
          $CellContext`S2[]],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
        $CellContext`S1[]] $CellContext`CD[-$CellContext`\[Beta]][
        $CellContext`S2[]]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Alpha]"], "S2"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Alpha]][
          $CellContext`S2[]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Beta]"], "S2"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Beta]][
          $CellContext`S2[]],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
        $CellContext`S2[]] $CellContext`CD[-$CellContext`\[Beta]][
        $CellContext`S2[]]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Alpha]"], "S2"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Alpha]][
          $CellContext`S2[]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Beta]"], "S2"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Beta]][
          $CellContext`S2[]],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
        $CellContext`S2[]] $CellContext`CD[-$CellContext`\[Beta]][
        $CellContext`S2[]]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S1[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S2[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S1[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S1[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S2[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S1[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S2[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S2[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S2[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S2[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S2[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S2[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], 
       SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`CD[-$CellContext`\[Alpha]][
       $CellContext`S1[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S1",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S1[],
    Editable->False]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], 
       SubscriptBox["\[Del]", "\[Alpha]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`CD[-$CellContext`\[Alpha]][
       $CellContext`S2[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S2",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S2[],
    Editable->False]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], 
       SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`CD[-$CellContext`\[Beta]][
       $CellContext`S1[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S1",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S1[],
    Editable->False]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], 
       SubscriptBox["\[Del]", "\[Beta]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`CD[-$CellContext`\[Beta]][
       $CellContext`S2[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S2",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S2[],
    Editable->False]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Nu]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Nu]][
      $CellContext`S1[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S2[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Nu]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Nu]][
      $CellContext`S1[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Nu]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Nu]][
      $CellContext`S1[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S2[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Nu]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Nu]][
      $CellContext`S1[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Nu]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Nu]][
      $CellContext`S2[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S2[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Nu]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Nu]][
      $CellContext`S2[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Nu]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Nu]][
      $CellContext`S2[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S2[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Nu]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Nu]][
      $CellContext`S2[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Nu]"], 
       SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Nu]][
      $CellContext`CD[-$CellContext`\[Alpha]][
       $CellContext`S1[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S1",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S1[],
    Editable->False]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Nu]"], 
       SubscriptBox["\[Del]", "\[Alpha]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Nu]][
      $CellContext`CD[-$CellContext`\[Alpha]][
       $CellContext`S2[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S2",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S2[],
    Editable->False]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Nu]"], 
       SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Nu]][
      $CellContext`CD[-$CellContext`\[Beta]][
       $CellContext`S1[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S1",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S1[],
    Editable->False]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Nu]"], 
       SubscriptBox["\[Del]", "\[Beta]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Nu]][
      $CellContext`CD[-$CellContext`\[Beta]][
       $CellContext`S2[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S2",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S2[],
    Editable->False]]}]], "Output",
 CellLabel->
  "Out[23]=",ExpressionUUID->"0c1c747b-feee-4ab4-8911-a29fb6cf95e5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ContractMetric", "[", "TS1S2R", "]"}], "//", 
  "ToCanonical"}]], "Input",
 CellLabel->"In[24]:=",ExpressionUUID->"85db8e57-f7eb-4c62-bda4-019c7adcdfbb"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "\[Nu]"},
             {"\[Beta]", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {" ", " "},
             {"\[Alpha]", "\[Mu]"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"g", 
              StyleBox[GridBox[{
                 {"\[Alpha]", "\[Beta]"},
                 {" ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->Rational[39, 4]]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`\[Alpha]][
           $CellContext`S1[]],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`\[Beta]][
           $CellContext`S1[]],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
         $CellContext`S1[]] $CellContext`CD[-$CellContext`\[Beta]][
         $CellContext`S1[]]],
      Editable->False]}], 
    SuperscriptBox[
     InterpretationBox[
      StyleBox["S1",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`S1[],
      Editable->False], "2"]]}], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Alpha]][
          $CellContext`S1[]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Beta]][
          $CellContext`S1[]],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
        $CellContext`S1[]] $CellContext`CD[-$CellContext`\[Beta]][
        $CellContext`S1[]]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Alpha]][
          $CellContext`S1[]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Beta]"], "S2"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Beta]][
          $CellContext`S2[]],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
        $CellContext`S1[]] $CellContext`CD[-$CellContext`\[Beta]][
        $CellContext`S2[]]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Alpha]][
          $CellContext`S1[]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Beta]"], "S2"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Beta]][
          $CellContext`S2[]],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
        $CellContext`S1[]] $CellContext`CD[-$CellContext`\[Beta]][
        $CellContext`S2[]]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Alpha]"], "S2"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Alpha]][
          $CellContext`S2[]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Beta]"], "S2"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Beta]][
          $CellContext`S2[]],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
        $CellContext`S2[]] $CellContext`CD[-$CellContext`\[Beta]][
        $CellContext`S2[]]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Alpha]"], "S2"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Alpha]][
          $CellContext`S2[]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Beta]"], "S2"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Beta]][
          $CellContext`S2[]],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
        $CellContext`S2[]] $CellContext`CD[-$CellContext`\[Beta]][
        $CellContext`S2[]]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S1[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S2[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S1[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S1[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S2[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S1[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S2[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S2[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S2[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S2[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S2[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S2[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], 
       SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`CD[-$CellContext`\[Alpha]][
       $CellContext`S1[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S1",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S1[],
    Editable->False]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], 
       SubscriptBox["\[Del]", "\[Alpha]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`CD[-$CellContext`\[Alpha]][
       $CellContext`S2[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S2",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S2[],
    Editable->False]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], 
       SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`CD[-$CellContext`\[Beta]][
       $CellContext`S1[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S1",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S1[],
    Editable->False]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], 
       SubscriptBox["\[Del]", "\[Beta]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`CD[-$CellContext`\[Beta]][
       $CellContext`S2[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S2",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S2[],
    Editable->False]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Nu]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Nu]][
      $CellContext`S1[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], "2"]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S2[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Nu]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Nu]][
      $CellContext`S1[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Nu]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Nu]][
      $CellContext`S1[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S2[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Nu]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Nu]][
      $CellContext`S1[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Nu]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Nu]][
      $CellContext`S2[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S2[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Nu]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Nu]][
      $CellContext`S2[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Nu]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Nu]][
      $CellContext`S2[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S2[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Nu]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Nu]][
      $CellContext`S2[]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False], "2"]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Nu]"], 
       SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Nu]][
      $CellContext`CD[-$CellContext`\[Alpha]][
       $CellContext`S1[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S1",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S1[],
    Editable->False]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Nu]"], 
       SubscriptBox["\[Del]", "\[Alpha]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Nu]][
      $CellContext`CD[-$CellContext`\[Alpha]][
       $CellContext`S2[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S2",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S2[],
    Editable->False]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Nu]"], 
       SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Nu]][
      $CellContext`CD[-$CellContext`\[Beta]][
       $CellContext`S1[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S1",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S1[],
    Editable->False]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Nu]"], 
       SubscriptBox["\[Del]", "\[Beta]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Nu]][
      $CellContext`CD[-$CellContext`\[Beta]][
       $CellContext`S2[]]],
     Editable->False]}], 
   InterpretationBox[
    StyleBox["S2",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`S2[],
    Editable->False]]}]], "Output",
 CellLabel->
  "Out[24]=",ExpressionUUID->"92d9bdc0-bfc0-47be-a8b7-7ac6f70f72fe"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "-", "%%"}], "//", "ToCanonical"}]], "Input",
 CellLabel->"In[25]:=",ExpressionUUID->"99d4ae0e-6658-4d59-8596-5c54add793e0"],

Cell[BoxData["0"], "Output",
 CellLabel->
  "Out[25]=",ExpressionUUID->"b3f432bd-05f3-4184-a233-e2a94b10988b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ContractMetric", "[", 
   RowBox[{"TS2TS1R", "-", "TS1R"}], "]"}], "//", "ToCanonical"}]], "Input",
 CellLabel->"In[27]:=",ExpressionUUID->"63e8a9db-cce9-44e5-ac04-28312ab3c2d6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"2", " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"\[Delta]", 
          StyleBox[GridBox[{
             {" ", "\[Nu]"},
             {"\[Beta]", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {" ", " "},
             {"\[Alpha]", "\[Mu]"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        StyleBox["(",
         FontColor->RGBColor[1, 0, 0]], 
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"g", 
              StyleBox[GridBox[{
                 {"\[Alpha]", "\[Beta]"},
                 {" ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
               FontSize->Rational[39, 4]]}
            },
            GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
            
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`\[Alpha]][
           $CellContext`S1[]],
          Editable->False], " ", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SubscriptBox["\[Del]", "\[Beta]"], "S2"}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[-$CellContext`\[Beta]][
           $CellContext`S2[]],
          Editable->False]}], 
        StyleBox[")",
         FontColor->RGBColor[1, 0, 0]]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
         $CellContext`S1[]] $CellContext`CD[-$CellContext`\[Beta]][
         $CellContext`S2[]]],
      Editable->False]}], 
    RowBox[{
     InterpretationBox[
      StyleBox["S1",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`S1[],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox["S2",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`S2[],
      Editable->False]}]]}], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       StyleBox["(",
        FontColor->RGBColor[1, 0, 0]], 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"\[Alpha]", "\[Beta]"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "Rows" -> {{
                    Offset[0.]}}}],
              FontSize->Rational[39, 4]]}
           },
           GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Alpha]][
          $CellContext`S1[]],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[Del]", "\[Beta]"], "S2"}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`\[Beta]][
          $CellContext`S2[]],
         Editable->False]}], 
       StyleBox[")",
        FontColor->RGBColor[1, 0, 0]]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`Scalar[$CellContext`g[$CellContext`\[Alpha], $CellContext`\
\[Beta]] $CellContext`CD[-$CellContext`\[Alpha]][
        $CellContext`S1[]] $CellContext`CD[-$CellContext`\[Beta]][
        $CellContext`S2[]]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S2[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S1[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S2[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S1[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Beta]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Beta], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S2[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Delta]", 
         StyleBox[GridBox[{
            {" ", "\[Nu]"},
            {"\[Alpha]", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTensor`delta[-$CellContext`\[Alpha], $CellContext`\[Nu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Mu]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Mu]][
      $CellContext`S2[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S2[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Nu]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Nu]][
      $CellContext`S1[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S2[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Nu]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Nu]][
      $CellContext`S1[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "-", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Beta]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Beta], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Nu]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Nu]][
      $CellContext`S2[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {" ", " "},
            {"\[Alpha]", "\[Mu]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "S1"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`S1[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[Del]", "\[Nu]"], "S2"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`\[Nu]][
      $CellContext`S2[]],
     Editable->False]}], 
   RowBox[{
    InterpretationBox[
     StyleBox["S1",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S1[],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox["S2",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S2[],
     Editable->False]}]]}]], "Output",
 CellLabel->
  "Out[27]=",ExpressionUUID->"81a4e8c6-104c-4912-8185-afd0d8fa094b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Antisymmetrize", "[", 
   RowBox[{"U", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Mu]"}], ",", "\[Nu]"}], "]"}], "]"}], "//", 
  "ToCanonical"}]], "Input",
 CellLabel->"In[35]:=",ExpressionUUID->"4d11606f-c268-4ca9-ae73-8b067f5af923"],

Cell[BoxData["0"], "Output",
 CellLabel->
  "Out[35]=",ExpressionUUID->"c0346278-ca42-487a-866d-78e142b875e9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"U", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Mu]"}], ",", 
     RowBox[{"-", "\[Nu]"}]}], "]"}], "-", 
   RowBox[{"U", "[", 
    RowBox[{
     RowBox[{"-", "\[Mu]"}], ",", 
     RowBox[{"-", "\[Nu]"}], ",", 
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}]}], "//", "ToCanonical"}]], "Input",
 CellLabel->"In[38]:=",ExpressionUUID->"71cf7e9b-b400-4c2f-91d9-192a326f3895"],

Cell[BoxData["0"], "Output",
 CellLabel->
  "Out[38]=",ExpressionUUID->"d551ac7d-e2b1-46a9-b296-736437c4f5ef"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1107, 847},
WindowMargins->{{95, Automatic}, {Automatic, 24}},
Visible->True,
DockedCells->{
  Cell[
   BoxData[
    TemplateBox[{
      ButtonBox[
      "\"\[Dagger]\"", ButtonFunction :> Exit[], Appearance -> Automatic, 
       Evaluator -> Automatic, Method -> "Preemptive"], 
      ButtonBox[
      "\"\[RightTriangle]\"", ButtonFunction :> FrontEnd`FrontEndExecute[
         FrontEnd`FrontEndToken["EvaluatorStart"]], Evaluator -> None, 
       Appearance -> Automatic, Method -> "Preemptive"], 
      ButtonBox[
      "\"\[RightTriangle]\[RightTriangle]\"", ButtonFunction :> 
       FrontEnd`FrontEndExecute[
         FrontEnd`FrontEndToken["EvaluateNotebook"]], Evaluator -> None, 
       Appearance -> Automatic, Method -> "Preemptive"], 
      ButtonBox["\"EvalInit\"", ButtonFunction :> FrontEnd`FrontEndExecute[
         FrontEnd`FrontEndToken["EvaluateInitialization"]], Evaluator -> None,
        Appearance -> Automatic, Method -> "Preemptive"], 
      ButtonBox[
      "\"Init\"", 
       ButtonFunction :> (Module[{Utility`Toolbar`cell = NotebookSelection[
             SelectedNotebook[]], Utility`Toolbar`isInit}, 
          Utility`Toolbar`isInit = ReplaceAll[InitializationCell, 
             Options[Utility`Toolbar`cell, InitializationCell]]; If[
            TrueQ[
             Or[
             Utility`Toolbar`isInit == True, Utility`Toolbar`isInit == On]], 
            SetOptions[Utility`Toolbar`cell, InitializationCell -> False], 
            SetOptions[Utility`Toolbar`cell, InitializationCell -> True]]]; 
        Null), Appearance -> Automatic, Evaluator -> Automatic, Method -> 
       "Preemptive"], 
      ButtonBox["\"DeInit\"", ButtonFunction :> SetOptions[
         NotebookSelection[
          SelectedNotebook[]], InitializationCell -> False], Appearance -> 
       Automatic, Evaluator -> Automatic, Method -> "Preemptive"], 
      ButtonBox["\"\[DeleteKey]\"", ButtonFunction :> FrontEnd`FrontEndExecute[
         FrontEnd`FrontEndToken["DeleteGeneratedCells"]], Evaluator -> None, 
       Appearance -> Automatic, Method -> "Preemptive"]}, "Row", 
     DisplayFunction -> (
      RowBox[{#, "\[InvisibleSpace]", #2, "\[InvisibleSpace]", #3, 
        "\[InvisibleSpace]", #4, "\[InvisibleSpace]", #5, 
        "\[InvisibleSpace]", #6, "\[InvisibleSpace]", #7}]& ), 
     InterpretationFunction -> (RowBox[{"Row", "[", 
        RowBox[{"{", 
          RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5, ",", #6, ",", #7}], 
          "}"}], "]"}]& )]], "DockedCell"]},
PrivateNotebookOptions->{"FileOutlineCache"->False},
ShowSelection->True,
TrackCellChangeTimes->False,
FrontEndVersion->"14.1 pour Mac OS X ARM (64-bit) (July 16, 2024)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "PastelColor.nb", 
  CharacterEncoding -> "UTF-8"],
ExpressionUUID->"759ac084-8680-4576-9642-eb256c36fbd0"
]

